


READMSG(1L)       MISC. REFERENCE MANUAL PAGES        READMSG(1L)



NAME
     readmsg - extract messages from a mail folder

SYNOPSIS
     readmsg [-anhp] [-f folder] [selection ...]

DESCRIPTION
     _R_e_a_d_m_s_g extracts selected mail messages from a mail  folder.
     One  helpful  use of the program is when you are composing a
     response to a mail message in an external editor.   In  this
     case,  you  can  run  _r_e_a_d_m_s_g to pull a copy of the original
     message into the editing buffer.  When you run _r_e_a_d_m_s_g  from
     within  _e_l_m  (e.g.  from a subshell escape or in an external
     editor while composing a mail reply) it behaves a  bit  dif-
     ferently  from  when  you run it directly (e.g. from a shell
     command line).  We will first describe its normal  behavior,
     and  then describe how it is different when you run it under
     _e_l_m.  You tell _r_e_a_d_m_s_g which messages to  extract  with  the
     _s_e_l_e_c_t_i_o_n  argument.   There  are  a couple of possible dif-
     ferent ways to specify the _s_e_l_e_c_t_i_o_n.

     1.   A lone ``*'' means select all messages in the mailbox.

     2.   A list of message numbers may be specified.  Values  of
          ``0''  and ``$'' in the list both mean the last message
          in the mailbox.  For example:

               readmsg 1 3 0

          extracts three messages from the  folder:   the  first,
          the third, and the last.

     3.   Finally, the _s_e_l_e_c_t_i_o_n may be some text to match.  This
          will  select  a  mail message which _e_x_a_c_t_l_y matches the
          specified text.  For example,

               readmsg staff meeting

          _e_x_t_r_a_c_t_s _t_h_e _m_e_s_s_a_g_e _w_h_i_c_h _c_o_n_t_a_i_n_s _t_h_e  _w_o_r_d_s  ``_s_t_a_f_f
          _m_e_e_t_i_n_g.''   _N_o_t_e _t_h_a_t _i_t _w_i_l_l _n_o_t match a message con-
          taining ``Staff Meeting''  the matching is case  sensi-
          tive.   Normally  only  the first message which matches
          the pattern will be printed.  The -a  option  discussed
          in  a  moment changes this.  The -f flag indicates that
          you'd rather use the folder specified rather  than  the
          default  incoming mailbox.  The specified _f_o_l_d_e_r can be
          a filename or a specification  such  as  ``=sentmail''.
          The -h flag instructs the program to include the entire
          header of the matched message or messages when display-
          ing their text.  (default is to display the From: Date:
          and Subject: lines only) The -n flag instructs the pro-
          gram  to  exclude _a_l_l headers.  This is used mostly for



USENET Community TrustLast change: Elm Version 2.4                 1






READMSG(1L)       MISC. REFERENCE MANUAL PAGES        READMSG(1L)



          extracting files mailed and such.  The  -p  flag  indi-
          cates  that the program should put form-feeds (control-
          L) between message headers.  The -a flag indicates that
          all  messages  which match the pattern specified on the
          command line should be printed, not just the first.  If
          a  pattern  was  not specified on the command line then
          this flag has no effect.  When you  run  _r_e_a_d_m_s_g  under
          _e_l_m (once again, say in the context of an external edi-
          tor) the behavior will be different from that described
          above as follows.

     1.   The default mail folder will  be  the  folder  you  are
          currently  examining  in  _e_l_m  and not necessarily your
          incoming mail folder.

     2.   You do not need to specify a _s_e_l_e_c_t_i_o_n on  the  command
          line.   If  you  omit  the  _s_e_l_e_c_t_i_o_n then _r_e_a_d_m_s_g will
          extract the message(s) you have selected  in  Elm.   If
          you  have tagged any messages then this would be all of
          the tagged messages, otherwise it would be the  message
          you are currently examining.

     3.   Normally the message numbers _r_e_a_d_m_s_g uses are in  mail-
          box  order.  When you call _r_e_a_d_m_s_g under _e_l_m and do not
          override the folder selection with the -f option,  then
          message numbers will be sorted as they are displayed on
          the _e_l_m message index screen.

EXAMPLES
     First off, to use this from within vi to include the text of
     the current message, you could use the command:

          :r !readmsg

     (as you hit the ':' the editor will put you at the bottom of
     the  screen  with the ':' prompt).  The space following ':r'
     is required.


     Let's look at something more interesting, however;

     Suppose you have the mail file;

        From joe Jun 3 1986 4:45:30 MST
        Subject: hello

        Hey Guy!  Wanta go out and have a milk this evening?

        Joe

        From john Jun 3 1986 4:48:20 MST
        Subject: Dinner at Eight



USENET Community TrustLast change: Elm Version 2.4                 2






READMSG(1L)       MISC. REFERENCE MANUAL PAGES        READMSG(1L)



        From: John Dinley <xyz!john>

        Remember you should show up about eight, okay?

                  - John D -

        From xxzyz!cron Jun 3 1986 5:02:43 MST

        Cannot connect to server: blob
        Job 43243 deleted from queue.

     The following commands will result in;

       $ readmsg 2
       [ display the second message, from John ]

       $ readmsg
       [ an error, unless we're calling from _e_l_m ]

       $ readmsg BLOB
       [ no match - case sensitive! ]

       $ readmsg -h connect to server
       [ displays third message, including headers ]


FILES
     /usr/mail/<username>          The incoming mail
     $ELMSTATE           Status information from _e_l_m

AUTHOR
     Elm Development Group

SEE ALSO
     newmail(1L), elm(1L)

BUGS
     The '*' metacharacter doesn't always work as expected!
     Perhaps the pattern matching should be case insensitive?
     It might be confusing that messages are sorted when  running
     under  _e_l_m with the current folder, and in mailbox order for
     all other cases.

BUG REPORTS TO
     Syd Weinstein  elm@DSI.COM    (dsinc!elm)

COPYRIGHTS
     Copyright 1988-1992 by The USENET Community Trust
     Derived from Elm 2.0,  Copyright 1986, 1987 by Dave Taylor






USENET Community TrustLast change: Elm Version 2.4                 3



